# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is Mozilla Communicator client code, released
# March 31, 1998.
#
# The Initial Developer of the Original Code is
# Netscape Communications Corporation.
# Portions created by the Initial Developer are Copyright (C) 1998-1999
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#  Prasad Sunkari <prasad@synovel.com>
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

const gMailAppName = "mailnews";

var mailAppObserver = {
   observe: function (aSubject, aTopic, aCurrentApp) {
      if (aTopic == "csApplicationSwitched" && aCurrentApp == gMailAppName)
         this.switchToMailnews();
   },

   switchToMailnews: function() {
       // Restore the previously focused element if any.
       var focusElement = gFocusElements[gMailAppName];
       if (!focusElement) {
         // Select inbox on default account and focus threaded pane
         try {
           var accountManager = Components.classes["@mozilla.org/messenger/account-manager;1"]
                                  .getService(Components.interfaces.nsIMsgAccountManager);
           var inboxFolder = GetInboxFolder(accountManager.defaultAccount.incomingServer);
           SelectFolder(inboxFolder.URI);
           focusElement = document.getElementById("threadTree");
         } catch(ex) {
           focusElement = document.getElementById("folderTree");
         }
       }
       focusElement.focus();
   },
}

// Enable app status in appInfo component
var mailnewsAppInfoClass = Components.classes["@synovel.com/collab/mailnews-appinfo;1"];
if (mailnewsAppInfoClass) {
    var mailnewsAppInfo = mailnewsAppInfoClass.getService(Components.interfaces.csIAppInfo);
    if (mailnewsAppInfo)
        mailnewsAppInfo.enabled = true;
}

function OnLoadCollabMessenger () {
    var tabcollab = document.getElementById ("tabcollab");
    var newTab = tabcollab.addTab (20);
    var StringBundle = document.getElementById("bundle_collab");
    newTab.setAttribute ("label", StringBundle.getString("mailNewsTitle"));

    newTab.setAttribute ("onselect", "setCurrentApp('" + gMailAppName + "')");
    newTab.setAttribute ("image", "chrome://messenger/skin/16x16/internet-mail.png");
    newTab.setAttribute ("type", "mailnews");
    newTab.setAttribute ("id", "tab-mailnews");
    newTab.setAttribute ("linkedpanel", "tabpanel-mailnews");

    getLinkedTabPanel(newTab).controllers
                             .appendController(DefaultMailnewsController);

    gObserverService.addObserver(mailAppObserver, "csApplicationSwitched", false);
    gObserverService.addObserver(updateMailToolbar, "mail:updateToolbarItems", false);
    OnLoadMessenger ();

    addCommonController(MailnewsGlobalController);
    MailnewsGlobalController.updateCommands();
}

var updateMailToolbar = {
  observe: function() {
    if (!gDBView)
      return;
    // Update the mail view-type command group based on current view.
    if (gDBView.viewFlags & nsMsgViewFlagsType.kGroupBySort)
      UpdateViewCommands("cmd_viewGrouped");
    else if (gDBView.viewFlags & nsMsgViewFlagsType.kThreadedDisplay )
      UpdateViewCommands("cmd_viewThreaded");
    else 
      UpdateViewCommands("cmd_viewList");
  }
}

addEventListener("load", OnLoadCollabMessenger, true);

